<?php
/**
 * 天天畅付
 * @author mapeijian
 */
namespace app\common\pay;
use think\Request;
use app\common\Pay;
require_once(ROOT_PATH.'extend/ttcf/lib/Utils.php');

require_once(ROOT_PATH.'extend/ttcf/lib/Payment.php');
class TtcfWxGzh extends Pay
{

    
    protected $code='';
    protected $error='';

    public function getCode()
    {
        return $this->code;
    }

    public function getError()
    {
        return $this->error;
    }

    public function order($outTradeNo,$subject,$totalAmount)
    {
        $pay = new \Payment($this->account->params->memberid,$this->account->params->key);
        $order = [];
     	$order['service'] = 'wx.h5';
    	$order['out_trade_no'] = $outTradeNo;
	    $order['amount'] = number_format($totalAmount,2,'.','');
	    $order['return_url'] = Request::instance()->domain().'/orderquery?orderid='.$outTradeNo; 
	    $order['subject'] = $subject;
     	$result = $pay->commit($order);
        if(!$result){
            $this->code    =201;
            $this->error = '调用接口失败';
            return false;
        }
        
        if($result['code'] == 0){
            $this->code    =0;
            $obj           =new \stdClass();
            $obj->pay_url  =$result['data']['result'];

            if (isset($_SERVER['HTTP_USER_AGENT']) && strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')) 
            {
                $obj->content_type = 2;
            } 
            else 
            {
                $obj->content_type = 7;
            }
    
            return $obj;
        }else{
            $this->code    =201;
            $this->error = isset($response['msg']) ? $response['msg'] : '支付失败';
            return false;
        }
        
        
        
        
        
    }

    /**
     * 页面回调
     */
    public function page_callback($params,$order)
    {
        header("Location:" . url('/orderquery',['orderid'=>$order->trade_no]));
    }

    /**
     * 服务器回调
     */
    public function notify_callback($params,$order)
    {
       if(\Utils::verifySign($this->account->params->key,$params)){
           if($params['status'] === 'FINISHED'){
			//订单支付成功  后续逻辑处理代码
			if ($order->total_price != $params['amount']) {
                    record_file_log('TtcfWxGzh_notify_error', '金额异常！' . "\r\n" . $order->trade_no . "\r\n订单金额：{$order->total_price}，已支付：{$params['amount']}");
                    die('金额异常！');
                }
                $this->completeOrder($order);
                echo 'ok';
                return true;
           }else{
             exit('fail');   
           }
       }else{
          exit('fail'); 
       }
        
        
    }

    /**
     * @param $params
     * @return string
     */
    protected function sign($params, $apikey)
    {
        ksort($params);
        $keyStr = '';
        foreach ($params as $key => $val) {
            $keyStr .= "$key=$val&";
        }
        $sign = strtoupper(md5($keyStr . "key=" . $apikey));
        return $sign;
    }

    protected function createForm($url, $data)
    {
        $str = '<!doctype html>
            <html>
                <head>
                    <meta charset="utf8">
                    <title>正在跳转付款页</title>
                </head>
                <body onLoad="document.pay.submit()">
                <form method="post" action="' . $url . '" name="pay">';

        foreach ($data as $k => $vo) {
            $str .= '<input type="hidden" name="' . $k . '" value="' . $vo . '">';
        }

        $str .= '</form>
                <body>
            </html>';
        return $str;
    }
    
    
}
?>